/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.lib.asyncprofiler;

import java.io.IOException;
import me.lucko.spark.lib.asyncprofiler.AsyncProfilerMXBean;
import me.lucko.spark.lib.asyncprofiler.Counter;

public class AsyncProfiler
implements AsyncProfilerMXBean {
    private static AsyncProfiler instance;

    private AsyncProfiler() {
    }

    public static AsyncProfiler getInstance() {
        return AsyncProfiler.getInstance(null);
    }

    public static synchronized AsyncProfiler getInstance(String libPath) {
        if (instance != null) {
            return instance;
        }
        if (libPath == null) {
            System.loadLibrary("asyncProfiler");
        } else {
            System.load(libPath);
        }
        instance = new AsyncProfiler();
        return instance;
    }

    @Override
    public void start(String event, long interval) throws IllegalStateException {
        if (event == null) {
            throw new NullPointerException();
        }
        this.start0(event, interval, true);
    }

    @Override
    public void resume(String event, long interval) throws IllegalStateException {
        if (event == null) {
            throw new NullPointerException();
        }
        this.start0(event, interval, false);
    }

    @Override
    public void stop() throws IllegalStateException {
        this.stop0();
    }

    @Override
    public native long getSamples();

    @Override
    public String getVersion() {
        try {
            return this.execute0("version");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String execute(String command) throws IllegalArgumentException, IllegalStateException, IOException {
        if (command == null) {
            throw new NullPointerException();
        }
        return this.execute0(command);
    }

    @Override
    public String dumpCollapsed(Counter counter) {
        try {
            return this.execute0("collapsed," + counter.name().toLowerCase());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String dumpTraces(int maxTraces) {
        try {
            return this.execute0(maxTraces == 0 ? "traces" : "traces=" + maxTraces);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String dumpFlat(int maxMethods) {
        try {
            return this.execute0(maxMethods == 0 ? "flat" : "flat=" + maxMethods);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void addThread(Thread thread) {
        this.filterThread(thread, true);
    }

    public void removeThread(Thread thread) {
        this.filterThread(thread, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterThread(Thread thread, boolean enable) {
        if (thread == null || thread == Thread.currentThread()) {
            this.filterThread0(null, enable);
        } else {
            Thread thread2 = thread;
            synchronized (thread2) {
                Thread.State state = thread.getState();
                if (state != Thread.State.NEW && state != Thread.State.TERMINATED) {
                    this.filterThread0(thread, enable);
                }
            }
        }
    }

    private native void start0(String var1, long var2, boolean var4) throws IllegalStateException;

    private native void stop0() throws IllegalStateException;

    private native String execute0(String var1) throws IllegalArgumentException, IllegalStateException, IOException;

    private native void filterThread0(Thread var1, boolean var2);
}

